﻿#include  "StdAfx.h"
#include  "ArchiveCategoryProvider.hpp"
#include  "COM.hpp"
#include  <propkey.h>
#include  <initguid.h>

// Name
// {77559890-8E11-48e2-9B72-585FBA9CFFF4}
DEFINE_GUID(CAT_GUID_NAME,0x77559890, 0x8e11, 0x48e2, 0x9b, 0x72, 0x58, 0x5f, 0xba, 0x9c, 0xff, 0xf4);

// Size
// {0210C647-A9B8-41fb-ACB7-3C57D27C5BC1}
DEFINE_GUID(CAT_GUID_SIZE, 0x210c647, 0xa9b8, 0x41fb, 0xac, 0xb7, 0x3c, 0x57, 0xd2, 0x7c, 0x5b, 0xc1);

CArchiveCategoryProvider::CArchiveCategoryProvider(IShellFolder2 *psf) : m_psf(psf)
{
  m_psf->AddRef();
}

CArchiveCategoryProvider::~CArchiveCategoryProvider()
{
  m_psf->Release();
}

// ICategoryProvider::CanCategorizeOnSCID
STDMETHODIMP CArchiveCategoryProvider::CanCategorizeOnSCID(__in const SHCOLUMNID *pscid)
{
  HRESULT hr = S_FALSE;
  if (IsEqualPropertyKey(*pscid, PKEY_ItemNameDisplay) ||
      IsEqualPropertyKey(*pscid, PKEY_Size))
  {        
    hr = S_OK;  
  }
    
  return hr;
}

// ICategoryProvider::GetDefaultCategory
STDMETHODIMP CArchiveCategoryProvider::GetDefaultCategory(__out GUID *pguid, __out SHCOLUMNID *pscid)
{
  HRESULT  hr = S_OK;
  *pguid = CAT_GUID_NAME;
  pscid = NULL;
  return hr;
}

// ICategoryProvider::GetCategoryForSCID
STDMETHODIMP CArchiveCategoryProvider::GetCategoryForSCID(__in const SHCOLUMNID *pscid, __out GUID *pguid)
{
  HRESULT hr = S_OK;

  if (IsEqualPropertyKey(*pscid, PKEY_ItemNameDisplay))
  {
    *pguid = CAT_GUID_NAME;
  }
  else if (IsEqualPropertyKey(*pscid, PKEY_Size))
  {
    *pguid = CAT_GUID_SIZE;
  }
  //else if (IsEqualPropertyKey(*pkey, PKEY_Microsoft_SDKSample_NumberOfSides))
  //{
  //  *pguid = CAT_GUID_SIDES;
  //}
  //else if (IsEqualPropertyKey(*pkey, PKEY_Microsoft_SDKSample_DirectoryLevel))
  //{
  //  *pguid = CAT_GUID_LEVEL;
  //}
  //else if (IsEqualGUID(pkey->fmtid, GUID_NULL))
  //{
  //  /* This can be called with a NULL
  //  format ID. This will happen if you have a category,
  //  not based on a column, that gets stored in the
  //  property bag. When a return is made to this item,
  //  it will call this function with a NULL format id. */

  //  *pguid = CAT_GUID_VALUE;
  //}
  else
  {
    hr = E_INVALIDARG;
  }

  return hr;
}

// ICategoryProvider::EnumCategories
STDMETHODIMP CArchiveCategoryProvider::EnumCategories(__out IEnumGUID **ppenum)
{
  if (0 == ppenum)
    return E_POINTER;

  *ppenum = 0;

  CComObject<CArchiveCategoryEnumGUID> *penum;
  HRESULT hr = CComObject<CArchiveCategoryEnumGUID>::CreateInstance(&penum);
  if (FAILED(hr))
    return hr;

  penum->AddRef(); // ここで使う間だけ AddRef しておく
  hr = penum->QueryInterface(IID_IEnumGUID, (void **)ppenum);
  penum->Release();

  return S_OK;
}

// ICategoryProvider::GetCategoryName
STDMETHODIMP CArchiveCategoryProvider::GetCategoryName(__in const GUID *pguid, __out LPWSTR pszName, __in UINT cch)
{
  HRESULT hr = E_FAIL;

//if (IsEqualGUID(*pguid, CAT_GUID_VALUE))
//{
//  hr = LoadStringW(g_hInst, IDS_VALUE, pszName, cch) ? S_OK : E_FAIL;
//}

  return hr;
}

// ICategoryProvider::CreateCategory
STDMETHODIMP CArchiveCategoryProvider::CreateCategory(__in const GUID *pguid, __in REFIID riid, __out void **ppv)
{
  HRESULT hr;
  *ppv = NULL;

  if (riid == IID_ICategorizer)
  {
    if (IsEqualGUID(*pguid, CAT_GUID_NAME))
    {
      //*ppv = new CArchiveCategorizerName(m_psf);
      //if (0 != *ppv)
      //  ((ICategorizer*)*ppv)->AddRef();
      //hr = *ppv ? S_OK : E_OUTOFMEMORY;
    }
    else if (IsEqualGUID(*pguid, CAT_GUID_SIZE))
    {
      //return EpoCreateInstance<CArchiveCategorizerName>(IID_ICategorizer, ppv);
    }
    //else if (IsEqualGUID(*pguid, CAT_GUID_VALUE))
    //{
    //  *ppv = new CFolderViewImplCategorizer_Value(m_psf);
    //  hr = *ppv ? S_OK : E_OUTOFMEMORY;
    //}
    else
    {
      hr = E_INVALIDARG;
    }
  }
  else
  {
    hr = E_NOINTERFACE;
  }

  return hr;
}

CArchiveCategoryEnumGUID::CArchiveCategoryEnumGUID()// : m_ulCurrentIndex(0)
{
}

CArchiveCategoryEnumGUID::~CArchiveCategoryEnumGUID()
{
}

// IEnumGUID::Next
STDMETHODIMP CArchiveCategoryEnumGUID::Next(__in ULONG celt, __out GUID *rgelt, __out ULONG *pceltFetched)
{
  //HRESULT hr = (celt != 1) ? E_INVALIDARG : S_OK;

  //if (SUCCEEDED(hr))
  //{
  //  hr = (m_ulCurrentIndex < MAX_CATEGORIES) ? S_OK : S_FALSE;
  //  if (S_OK == hr)
  //  {
  //    switch (m_ulCurrentIndex++)
  //    {
  //    case 0:
  //      *rgelt = CAT_GUID_VALUE;
  //      break;
  //    }
  //  }
  //}

  //return hr;
  return (celt != 1) ? E_INVALIDARG : S_FALSE;
}

// IEnumGUID::Clone
STDMETHODIMP CArchiveCategoryEnumGUID::Skip(__in ULONG celt)
{
  return S_OK;
}

// IEnumGUID::Clone
STDMETHODIMP CArchiveCategoryEnumGUID::Reset()
{
  return S_OK;
}

// IEnumGUID::Clone
STDMETHODIMP CArchiveCategoryEnumGUID::Clone(__out IEnumGUID **ppenum)
{
  *ppenum = NULL;
  return E_NOTIMPL;
}

CArchiveCategorizerName::CArchiveCategorizerName(IShellFolder2 *psf) : m_psf(psf)
{
  m_psf->AddRef();
}

CArchiveCategorizerName::~CArchiveCategorizerName()
{
  m_psf->Release();
}

// ICategorizer
STDMETHODIMP CArchiveCategorizerName::GetDescription(__out LPWSTR pszDesc, __in UINT cch)
{
  return S_OK;
}

STDMETHODIMP CArchiveCategorizerName::GetCategory(__in UINT cidl, __in PCUITEMID_CHILD_ARRAY apidl, __out DWORD *rgCategoryIds)
{
  return S_OK;
}

STDMETHODIMP CArchiveCategorizerName::GetCategoryInfo(__in DWORD dwCategoryId, __out CATEGORY_INFO *pci)
{
  return S_OK;
}

STDMETHODIMP CArchiveCategorizerName::CompareCategory(__in CATSORT_FLAGS csfFlags, __in DWORD dwCategoryId1, __in DWORD dwCategoryId2)
{
  return S_OK;
}
